LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;
use work.constants.all;
use work.func_external.all;


entity mac_ccm is
	port 
	(
		mac_clk					: in std_logic;
		mac_pixel_value			: in integer;
		mac_pixel_valid			: in std_logic;
		mac_kernel_value		: in integer;
		mac_kernel_valid		: in std_logic;
		mac_reset				: in std_logic;
		mac_enable				: in std_logic;
		one_stripe_done : in integer;
		mac_x 			:in integer;
		mac_y 			:in integer;
		mac_z 			:in integer;
		kernel_number    :in integer;

		compute_done_out : out std_logic;
		output0			: out integer;
		output1			: out integer
	);
	
end entity;

architecture rtl of mac_ccm is

	-- Declare registers for intermediate values
	signal mac_kernel_value_reg : integer;
	signal mac_pixel_value_reg : integer;
	signal tmp_signal : integer;
	--signal adder_out : unsigned (31 downto 0);
	--signal old_result : unsigned (31 downto 0);

	signal mac_index2,mac_index3,mac_index4,mac_index6 : integer;
	signal mac_x_reg,mac_y_reg,mac_z_reg : integer;
	signal buffer_shift3,buffer_shift4,buffer_shift5 : integer;
	signal compute_done : std_logic;
	signal index: integer;
	--signal mac_stop : integer;
	--signal mac_stop_buffer : integer;
	signal kernel_value_buffer: integer;
	signal calc_iteration : integer;

	type memory is array (0 to 5 ) of integer ;  
	signal buffer_value  : memory;

	type type_state is (prepare,reset,done,halt,stripe_switch,buffer_shift_row3,buffer_shift_row4,buffer_shift_row5,
						pixel_00,pixel_01,pixel_02,pixel_03,pixel_10,pixel_11,pixel_12,pixel_13,pixel_20,pixel_21,pixel_22,pixel_23,
						pixel_30,pixel_31,pixel_32,pixel_33,pixel_34,pixel_35,pixel_04,pixel_05,pixel_14,pixel_15,pixel_24,pixel_25);
	signal current_state,next_state,tmp_state : type_state;
	signal mac_pixel_valid_reg, mac_kernel_valid_reg : std_logic;
signal mac_x_reg_std : std_logic_vector (31 downto 0);
signal mac_y_reg_std : std_logic_vector (31 downto 0);
signal mac_z_reg_std : std_logic_vector (31 downto 0);
begin

compute_done_out  <= compute_done;

store_input :	process(mac_clk, mac_enable, mac_reset)
	begin
		if(mac_reset = '1') then
			mac_x_reg <= 0;
			mac_y_reg <= 0;
			mac_z_reg <= 0;

			mac_kernel_value_reg  <= 0;
			mac_kernel_valid_reg  <= '0';

			mac_pixel_value_reg  <= 0;
			mac_pixel_valid_reg  <= '0';
			--mac_kernel_value_reg  <= (others => '0');
			--mac_pixel_value_reg  <= (others => '0');


		elsif(mac_enable = '1') then

			if(rising_edge(mac_clk)) then
				mac_x_reg  <= mac_x;
				mac_y_reg  <= mac_y;
				mac_z_reg  <= mac_z;

				mac_kernel_value_reg  <= mac_kernel_value;
				mac_kernel_valid_reg  <= mac_kernel_valid;

				mac_pixel_value_reg  <= mac_pixel_value;				
				mac_pixel_valid_reg  <= mac_pixel_valid;

			end if;
		end if;
	end process store_input;

mac_x_reg_std  <=  std_logic_vector(to_unsigned(mac_x_reg,32));
mac_y_reg_std  <=  std_logic_vector(to_unsigned(mac_y_reg,32));
mac_z_reg_std  <=  std_logic_vector(to_unsigned(mac_z_reg,32));
--------------------------------------------------------------------------------
-- next state
--------------------------------------------------------------------------------
	
next_state_generation: process(mac_clk,mac_reset,mac_x,mac_y,mac_z)
variable  hello: integer ;
begin
	if (mac_reset = '1') then
			current_state  <= reset;
			index  <= 0;
			hello := 10;
	elsif (rising_edge(mac_clk)) then
			if (mac_enable = '1') then
				current_state  <= next_state;
					if( index  <= 16) then 
						index  <= index + 1;
					else 
						index  <= 0;
					end if;
			else 
				current_state  <= reset;
			end if;
	end if;
end process next_state_generation ;		
			

--------------------------------------------------------------------------------
-- future state network
--------------------------------------------------------------------------------


future_state_network : process(current_state,index)
begin
	
	case current_state is

		when reset => 
			mac_index2  <= 0;
			mac_index3  <= 0;
			mac_index4  <= 0;
			mac_index6  <= 0;
			if (mac_enable = '1') then
			 	if (mac_pixel_valid_reg = '1' and mac_kernel_valid_reg = '1') then

					next_state  <= prepare;
				else 
					next_state  <= reset;
				end if;
			else
				next_state  <= reset;
			end if;

		when halt  => 
			if mac_enable = '1' then 
				if ( one_stripe_done = 0) then		
					--if mac_stop = 0 then 
					 if (mac_pixel_valid_reg = '1' and mac_kernel_valid_reg = '1') then

						next_state  <= prepare;
					else
						next_state  <= halt;
					end if; 
				else
					next_state  <= stripe_switch;
				end if;
			else
				next_state  <= reset;
			end if;

		when stripe_switch  => 
			mac_index2  <= 0;
			mac_index3  <= 0;
			mac_index4  <= 0;
			mac_index6  <= 0;
			if mac_enable = '1' then 
				--if (mac_stop = 0) then 
				 if (mac_pixel_valid_reg = '1' and mac_kernel_valid_reg = '1') then

					next_state  <= prepare;
				else
					next_state  <= halt;
				end if;
			else
				next_state  <= reset;
			end if;

		when buffer_shift_row3  => 
			next_state  <= tmp_state;

		when buffer_shift_row4  => 
			next_state  <= tmp_state;

		when buffer_shift_row5  => 
			next_state  <= tmp_state;

		when done  => 
			if mac_enable = '1' then 
				--if (mac_stop = 0) then 
				 if (mac_pixel_valid_reg = '1' and mac_kernel_valid_reg = '1') then

					next_state  <= prepare;
				else
					next_state  <= halt;
				end if;
			else
				next_state  <= reset;
			end if;


		when prepare  => 
			mac_index2  <= 0;
			mac_index3  <= 0;
			mac_index4  <= 0;
			mac_index6  <= 0;
			if (mac_enable = '1') then
				--if ( mac_stop = 0) then
					if ( one_stripe_done = 0) then  

						if ( mac_y_reg = 0 ) then
							--if ( mac_x_reg = 0 or mac_x_reg = 4) then
							if ( mac_x_reg_std(0) = '0' and mac_x_reg_std(1) = '0' ) then  -- the pixel x value is 0/4/8/12...
								next_state  <= pixel_00;
							elsif ( mac_x_reg_std(0) = '1' and mac_x_reg_std(1) = '0' ) then  -- the pixel x value is 1/5/9/13...
								next_state  <= pixel_10;
							elsif ( mac_x_reg_std(0) = '0' and mac_x_reg_std(1) = '1' ) then  --the pixel x value is 2/6/10/14...
								next_state  <= pixel_20;
							elsif (  mac_x_reg_std(0) = '1' and mac_x_reg_std(1) = '1' ) then  -- the pixel x value is 3/7/11/15
								next_state  <= pixel_30;
							end if;

						elsif ( mac_y_reg = 1 ) then
							if ( mac_x_reg_std(0) = '0' and mac_x_reg_std(1) = '0' ) then
								next_state  <= pixel_01;
							elsif ( mac_x_reg_std(0) = '1' and mac_x_reg_std(1) = '0' ) then
								next_state  <= pixel_11;
							elsif ( mac_x_reg_std(0) = '0' and mac_x_reg_std(1) = '1' ) then
								next_state  <= pixel_21;
							elsif (  mac_x_reg_std(0) = '1' and mac_x_reg_std(1) = '1' ) then
								next_state  <= pixel_31;
							end if;

						elsif ( mac_y_reg = 2 ) then
							if ( mac_x_reg_std(0) = '0' and mac_x_reg_std(1) = '0' ) then
								next_state  <= pixel_02;
							elsif ( mac_x_reg_std(0) = '1' and mac_x_reg_std(1) = '0' ) then
								next_state  <= pixel_12;
							elsif ( mac_x_reg_std(0) = '0' and mac_x_reg_std(1) = '1' ) then
								next_state  <= pixel_22;
							elsif (  mac_x_reg_std(0) = '1' and mac_x_reg_std(1) = '1' ) then
								next_state  <= pixel_32;
							end if;

						elsif ( mac_y_reg > 2 and mac_y_reg < SIZE_input_image_horizontal - 2 ) then
							if ( mac_x_reg_std(0) = '0' and mac_x_reg_std(1) = '0' ) then
								next_state  <= pixel_03;
							elsif ( mac_x_reg_std(0) = '1' and mac_x_reg_std(1) = '0' ) then
								next_state  <= pixel_13;
							elsif ( mac_x_reg_std(0) = '0' and mac_x_reg_std(1) = '1' ) then
								next_state  <= pixel_23;
							elsif (  mac_x_reg_std(0) = '1' and mac_x_reg_std(1) = '1' ) then
								next_state  <= pixel_33;
							end if;

						elsif ( mac_y_reg = SIZE_input_image_horizontal - 2 ) then
							if ( mac_x_reg_std(0) = '0' and mac_x_reg_std(1) = '0' ) then
								next_state  <= pixel_04;
							elsif ( mac_x_reg_std(0) = '1' and mac_x_reg_std(1) = '0' ) then
								next_state  <= pixel_14;
							elsif ( mac_x_reg_std(0) = '0' and mac_x_reg_std(1) = '1' ) then
								next_state  <= pixel_24;
							elsif (  mac_x_reg_std(0) = '1' and mac_x_reg_std(1) = '1' ) then
								next_state  <= pixel_34;
							end if;

						elsif ( mac_y_reg = SIZE_input_image_horizontal - 1 ) then
							if ( mac_x_reg_std(0) = '0' and mac_x_reg_std(1) = '0' ) then
								next_state  <= pixel_05;
							elsif ( mac_x_reg_std(0) = '1' and mac_x_reg_std(1) = '0' ) then
								next_state  <= pixel_15;
							elsif ( mac_x_reg_std(0) = '0' and mac_x_reg_std(1) = '1' ) then
								next_state  <= pixel_25;
							elsif (  mac_x_reg_std(0) = '1' and mac_x_reg_std(1) = '1' ) then
								next_state  <= pixel_35;
							end if;

						end if;

					else
						next_state  <= stripe_switch;
					end if;
				--else
					--next_state  <= halt;
				--end if;
			else
				next_state  <= reset;
			end if;	
			

--------------------------------------------------------------------------------
-- column0 transfer
--------------------------------------------------------------------------------

		when pixel_00  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then
				next_state  <= done;
			else
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;

		when pixel_10  =>
		--if ( mac_stop = 0 or mac_stop_buffer = 0) then 
			if ( one_stripe_done = 0) then
				if ( mac_index2 = 0) then
					next_state  <= pixel_10;
					mac_index2  <= mac_index2 + 1;
				elsif ( mac_index2 = 1) then 
					next_state  <= done;
				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;

		when pixel_20  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then
				if ( mac_index2 = 0) then
					next_state  <= pixel_20;
					mac_index2  <= mac_index2 + 1;
				elsif ( mac_index2 = 1) then
					next_state  <= done;
				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;

		when pixel_30  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then
				next_state  <= done;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;
--------------------------------------------------------------------------------
-- column1 transfer
--------------------------------------------------------------------------------

		when pixel_01  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then
				if ( mac_index2 = 0) then
					next_state  <= pixel_01;
					mac_index2  <= mac_index2 + 1;
				elsif ( mac_index2 = 1) then
					next_state  <= done;
				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;

		when pixel_11  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then
				if ( mac_index4 < 3) then
					next_state  <= pixel_11;
					mac_index4  <= mac_index4 + 1;
				elsif ( mac_index4 = 3) then
					next_state  <= done;
				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;

		when pixel_21  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then
				if ( mac_index4 < 3) then
					next_state  <= pixel_21;
					mac_index4  <= mac_index4 + 1;
				elsif ( mac_index4 = 3) then 
					next_state  <= done;
				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;

		when pixel_31  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then
				if ( mac_index2 = 0) then
					next_state  <= pixel_31;
					mac_index2  <= mac_index2 + 1;
				elsif ( mac_index2 = 1) then
					next_state  <= done;
				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;		
--------------------------------------------------------------------------------
-- column2 transfer
--------------------------------------------------------------------------------

		when pixel_02  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then
				if ( mac_index3 < 2) then
					next_state  <= pixel_02;
					mac_index3  <= mac_index3 + 1;
				elsif (mac_index3 = 2) then
					next_state  <= done;
				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;		

		when pixel_12  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then
				if ( mac_index6 < 5) then
					next_state  <= pixel_12;
					mac_index6  <= mac_index6 + 1;
				elsif ( mac_index6 = 5) then
					next_state  <= done;
				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;		

		when pixel_22  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then
				if ( mac_index6 < 5) then
					next_state  <= pixel_22;
					mac_index6  <= mac_index6 + 1;
				elsif ( mac_index6 = 5) then
					next_state  <= done;
				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;	

		when pixel_32  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then
				if ( mac_index3 < 2) then
					next_state  <= pixel_32;
					mac_index3  <= mac_index3 + 1;
				elsif ( mac_index3 = 2) then
					next_state  <= done;
				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;	
------------------------------------------------------------------------------
-- column 3 transfer
--------------------------------------------------------------------------------

		when pixel_03  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then
				if (buffer_shift3 = 1) then
					tmp_state  <= current_state;

				
					if ( mac_index3 < 2) then
						next_state  <= pixel_03;
						mac_index3  <= mac_index3 + 1;
					elsif ( mac_index3 = 2) then 
						next_state  <= done;
						next_state  <= buffer_shift_row3;
					end if;

				elsif (buffer_shift3 = 0) then
					if ( mac_index3 < 2) then
						next_state  <= pixel_03;
						mac_index3  <= mac_index3 + 1;
					elsif ( mac_index3 = 2) then 
						next_state  <= done;
					end if;


				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;	

		when pixel_13  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then

				if (buffer_shift3 = 1) then
					tmp_state  <= current_state;

					if ( mac_index6 < 5) then
						next_state  <= pixel_13;
						mac_index6  <= mac_index6 + 1;
					elsif ( mac_index6 = 5) then
						next_state  <= done;
						next_state  <= buffer_shift_row3;
					end if;

				elsif (buffer_shift3 = 0) then

					if ( mac_index6 < 5) then
						next_state  <= pixel_13;
						mac_index6  <= mac_index6 + 1;
					elsif ( mac_index6 = 5) then
						next_state  <= done;
					end if;


				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;	

		when pixel_23  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then

				if (buffer_shift3 = 1) then
					tmp_state  <= current_state;

					if ( mac_index6 < 5) then
						next_state  <= pixel_23;
						mac_index6  <= mac_index6 + 1;
					elsif ( mac_index6 = 5 ) then
						next_state  <= done;
						next_state  <= buffer_shift_row3;
					end if;

				elsif (buffer_shift3 = 0) then

					if ( mac_index6 < 5) then
						next_state  <= pixel_23;
						mac_index6  <= mac_index6 + 1;
					elsif ( mac_index6 = 5 ) then
						next_state  <= done;
					end if;


				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;	

		when pixel_33  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then

				if (buffer_shift3 = 1) then
					tmp_state  <= current_state;

					if ( mac_index3 < 2) then
						next_state  <= pixel_33;
						mac_index3  <= mac_index3 + 1;
					elsif ( mac_index3 = 2) then 
						next_state  <= done;
						next_state  <= buffer_shift_row3;
					end if;

				elsif (buffer_shift3 = 0) then

					if ( mac_index3 < 2) then
						next_state  <= pixel_33;
						mac_index3  <= mac_index3 + 1;
					elsif ( mac_index3 = 2) then 
						next_state  <= done;
					end if;
				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;	
-----------------------------------------------------------------------------
--  column 4 transfer 
-----------------------------------------------------------------------------
   
		when pixel_04  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then
				if (buffer_shift4 = 1) then
					tmp_state  <= current_state;

					if ( mac_index2 = 0) then
						next_state  <= pixel_04;
						mac_index2  <= mac_index2 + 1;
					elsif ( mac_index2 = 1) then
						next_state  <= done;
						next_state  <= buffer_shift_row4;
					end if;

				elsif (buffer_shift4 = 0) then

					if ( mac_index2 = 0) then
						next_state  <= pixel_04;
						mac_index2  <= mac_index2 + 1;
					elsif ( mac_index2 = 1) then
						next_state  <= done;
					end if;
				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;	

		when pixel_34  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then

				if (buffer_shift4 = 1) then
					tmp_state  <= current_state;

					if ( mac_index2 = 0 ) then
						next_state  <= pixel_34;
						mac_index2  <= mac_index2 + 1;
					elsif ( mac_index2 = 1) then
						next_state  <= done;
						next_state  <= buffer_shift_row4;
					end if;

				elsif (buffer_shift4 = 0) then

					if ( mac_index2 = 0 ) then
						next_state  <= pixel_34;
						mac_index2  <= mac_index2 + 1;
					elsif ( mac_index2 = 1) then
						next_state  <= done;
					end if;

				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;	

		when pixel_14  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then

				if (buffer_shift4 = 1) then
					tmp_state  <= current_state;

					if ( mac_index4 < 3) then
						next_state  <= pixel_14;
						mac_index4  <= mac_index4 + 1;
					elsif ( mac_index4 = 3) then 
						next_state  <= done;
						next_state  <= buffer_shift_row4;
					end if;

				elsif (buffer_shift4 = 0) then

					if ( mac_index4 < 3) then
						next_state  <= pixel_14;
						mac_index4  <= mac_index4 + 1;
					elsif ( mac_index4 = 3) then 
						next_state  <= done;
					end if;

				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;	

		when pixel_24  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then

				if (buffer_shift4 = 1) then
					tmp_state  <= current_state;

					if ( mac_index4 < 3) then
						next_state  <= pixel_24;
						mac_index4  <= mac_index4 + 1;
					elsif ( mac_index4 = 3) then
						next_state  <= done;
						next_state  <= buffer_shift_row4;
					end if;

				elsif (buffer_shift4 = 0) then

					if ( mac_index4 < 3) then
						next_state  <= pixel_24;
						mac_index4  <= mac_index4 + 1;
					elsif ( mac_index4 = 3) then
						next_state  <= done;
					end if;

				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;	
--------------------------------------------------------------------------------
-- column5 transfer 
--------------------------------------------------------------------------------

		when pixel_05  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then

				if (buffer_shift5 = 1) then
					next_state  <= buffer_shift_row5;
					--tmp_state  <= current_state;

				else
					next_state  <= done;
				end if;



			else
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;

		when pixel_35  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then

				if (buffer_shift5 = 1) then
					next_state  <= buffer_shift_row5;
					--tmp_state  <= current_state;

				else
					next_state  <= done;
				end if;

				
			else
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;

		when pixel_15  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then
				if (buffer_shift5 = 1) then
					next_state  <= buffer_shift_row5;
					tmp_state  <= current_state;

				else
					if ( mac_index2 = 0) then
						next_state  <= pixel_15;
						mac_index2  <= mac_index2 + 1;
					elsif ( mac_index2 = 1) then 
						next_state  <= done;
					end if;
				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;		

		when pixel_25  =>
		--if ( mac_stop = 0 ) then 
			if ( one_stripe_done = 0) then
				if (buffer_shift4 = 1) then
					next_state  <= buffer_shift_row4;
					tmp_state  <= current_state;

				else		
					if ( mac_index2 = 0 ) then
						next_state  <= pixel_25;
						mac_index2  <= mac_index2 + 1;
					elsif ( mac_index2 = 1 ) then 
						next_state  <= done;
					end if;
				end if;
			else 
				next_state  <= stripe_switch;
			end if; 
		--else
			--next_state  <= halt;
		--end if;

	end case;
end process future_state_network;



--------------------------------------------------------------------------------
-- output network
--------------------------------------------------------------------------------

output_network : process(current_state,index,mac_x) is    	--mac_x is in the sensitivity list to avoid two prcoess with same sen list
	variable tmp : integer;									-- that will make the variable invisible during Modelsim simulation
begin
		--if mac_pixel_valid = '1'  and mac_kernel_valid = '1' then
		--	mac_stop  <= 0;
		--else
		--	mac_stop  <= 1;
		--end if;

		tmp_signal  <= tmp;
		case current_state is

			when reset => 

				buffer_value <= (others => 0);
				buffer_shift3  <= 1;
				buffer_shift4  <= 1;
				buffer_shift5  <= 1;
				compute_done  <= '0';
				output0  <= 0;
				output1  <= 0;
				tmp := 0;


			when stripe_switch => 

			when halt  => 
				compute_done  <= '0';

			when done  => 
				compute_done  <= '1';

			when prepare  => 
				buffer_shift3  <= 1;
				buffer_shift4  <= 1;
				buffer_shift5  <= 1;
				compute_done  <= '0';
				output0  <= 0;
				output1  <= 0;
				tmp := 0;


			when buffer_shift_row3  => 
				output0  <= buffer_value(0);
				output1  <= buffer_value(3);
				buffer_value(0)  <= buffer_value(1);
				buffer_value(3)  <= buffer_value(4);
				buffer_value(1)  <= buffer_value(2);
				buffer_value(4)  <= buffer_value(5);
				buffer_value(2)	  <= 0;
				buffer_value(5)	  <= 0;

				buffer_shift3  <= 0;

			when buffer_shift_row4  => 
				output0  <= buffer_value(0);
				output1  <= buffer_value(3);
				buffer_shift4  <= 0;
				buffer_value(0)  <= buffer_value(1);
				buffer_value(3)  <= buffer_value(4);
				buffer_value(1)  <= buffer_value(2);
				buffer_value(4)  <= buffer_value(5);
				buffer_value(2)	  <= 0;
				buffer_value(5)	  <= 0;

			when buffer_shift_row5  => 
				output0  <= buffer_value(0);
				output1  <= buffer_value(3);
				buffer_shift5  <= 0;
				buffer_value(0)  <= buffer_value(1);
				buffer_value(3)  <= buffer_value(4);
				buffer_value(1)  <= buffer_value(2);
				buffer_value(4)  <= buffer_value(5);
				buffer_value(2)	  <= 0;
				buffer_value(5)	  <= 0;

--------------------------------------------------------------------------------
-- column 0
--------------------------------------------------------------------------------


			when pixel_00  => 
				tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				buffer_value(0) <= buffer_value(0) + tmp;
				--compute_done  <= '1';

			when pixel_10  => 

			tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if( mac_index2 = 0 ) then
					buffer_value(0) <= buffer_value(0) + tmp;
				elsif ( mac_index2 = 1) then
					buffer_value(3) <= buffer_value(3) + tmp;
					--compute_done  <= '1';
				end if;

			when pixel_20  =>
			tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;
 
				if( mac_index2 = 0 ) then
					buffer_value(3) <= buffer_value(3) + tmp;
				elsif ( mac_index2 = 1) then
					buffer_value(0) <= buffer_value(0) + tmp;
					--compute_done  <= '1';
				end if;

			when pixel_30  =>
			tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;
 
				buffer_value(3) <= buffer_value(3) + tmp;
				--compute_done  <= '1';

--------------------------------------------------------------------------------
-- column1
--------------------------------------------------------------------------------


			when pixel_01  => 
			tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if( mac_index2 = 0 ) then
					buffer_value(1) <= buffer_value(1) + tmp;
				elsif ( mac_index2 = 1) then
					buffer_value(0) <= buffer_value(0) + tmp;
					--compute_done  <= '1';

				end if;

			when pixel_11  => 
			tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if( mac_index4 = 0 ) then
					buffer_value(4) <= buffer_value(4) + tmp;
				elsif ( mac_index4 = 1) then
					buffer_value(3) <= buffer_value(3) + tmp;
				elsif ( mac_index4 = 2) then
					buffer_value(1) <= buffer_value(1) + tmp;
				elsif ( mac_index4 = 3) then
					buffer_value(0) <= buffer_value(0) + tmp;
					--compute_done  <= '1';

				end if;

			when pixel_21  => 
			tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if( mac_index4 = 0 ) then
					buffer_value(4) <= buffer_value(4) + tmp;
				elsif ( mac_index4 = 1) then
					buffer_value(3) <= buffer_value(3) + tmp;
				elsif ( mac_index4 = 2) then
					buffer_value(1) <= buffer_value(1) + tmp;
				elsif ( mac_index4 = 3) then
					buffer_value(0) <= buffer_value(0) + tmp;
					--compute_done  <= '1';

				end if;

			when pixel_31  => 
			tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if( mac_index2 = 0 ) then
					buffer_value(4) <= buffer_value(4) + tmp;
				elsif ( mac_index2 = 1) then
					buffer_value(3) <= buffer_value(3) + tmp;
					--compute_done  <= '1';

				end if;
--------------------------------------------------------------------------------
-- column 2
--------------------------------------------------------------------------------



			when pixel_02  => 
			tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if( mac_index3 = 0 ) then
					buffer_value(2) <= buffer_value(2) + tmp;
				elsif ( mac_index3 = 1) then
					buffer_value(1) <= buffer_value(1) + tmp;
				elsif ( mac_index3 = 2) then
					buffer_value(0) <= buffer_value(0) + tmp;
					--compute_done  <= '1';

				end if;

			when pixel_12  => 
			tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if( mac_index6 = 0 ) then
					buffer_value(5) <= buffer_value(5) + tmp;
				elsif ( mac_index6 = 1) then
					buffer_value(4) <= buffer_value(4) + tmp;
				elsif ( mac_index6 = 2) then
					buffer_value(3) <= buffer_value(3) + tmp;
				elsif ( mac_index6 = 3) then
					buffer_value(2) <= buffer_value(2) + tmp;
				elsif ( mac_index6 = 4) then
					buffer_value(1) <= buffer_value(1) + tmp;
				elsif ( mac_index6 = 5) then
					buffer_value(0) <= buffer_value(0) + tmp;
					--compute_done  <= '1';

				end if;

			when pixel_22  => 
			tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if( mac_index6 = 0 ) then
					buffer_value(5) <= buffer_value(5) + tmp;
				elsif ( mac_index6 = 1) then
					buffer_value(4) <= buffer_value(4) + tmp;
				elsif ( mac_index6 = 2) then
					buffer_value(3) <= buffer_value(3) + tmp;
				elsif ( mac_index6 = 3) then
					buffer_value(2) <= buffer_value(2) + tmp;
				elsif ( mac_index6 = 4) then
					buffer_value(1) <= buffer_value(1) + tmp;
				elsif ( mac_index6 = 5) then
					buffer_value(0) <= buffer_value(0) + tmp;
					--compute_done  <= '1';

				end if;


			when pixel_32  => 
			tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if( mac_index3 = 0 ) then
					buffer_value(5) <= buffer_value(5) + tmp;
				elsif ( mac_index3 = 1) then
					buffer_value(4) <= buffer_value(4) + tmp;
				elsif ( mac_index3 = 2) then
					buffer_value(3) <= buffer_value(3) + tmp;
					--compute_done  <= '1';

				end if;

--------------------------------------------------------------------------------
-- column 3
--------------------------------------------------------------------------------


				when pixel_03  => 
				tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if ( buffer_shift3 = 0) then 
					if( mac_index3 = 0 ) then
						buffer_value(2) <= buffer_value(2) + tmp;
					elsif ( mac_index3 = 1) then
						buffer_value(1) <= buffer_value(1) + tmp;
					elsif ( mac_index3 = 2) then
						buffer_value(0) <= buffer_value(0) + tmp;
						--compute_done  <= '1';
					end if;
				end if;
					

				when pixel_13  => 
				tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if ( buffer_shift3 = 0) then 
					if( mac_index6 = 0 ) then
						buffer_value(5) <= buffer_value(5) + tmp;
					elsif ( mac_index6 = 1) then
						buffer_value(4) <= buffer_value(4) + tmp;
					elsif ( mac_index6 = 2) then
						buffer_value(3) <= buffer_value(3) + tmp;
					elsif ( mac_index6 = 3) then
						buffer_value(2) <= buffer_value(2) + tmp;
					elsif ( mac_index6 = 4) then
						buffer_value(1) <= buffer_value(1) + tmp;
					elsif ( mac_index6 = 5) then
						buffer_value(0) <= buffer_value(0) + tmp;
						--compute_done  <= '1';

					end if;
				end if;

				when pixel_23  => 
				tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if ( buffer_shift3 = 0) then 
					if( mac_index6 = 0 ) then
						buffer_value(5) <= buffer_value(5) + tmp;
					elsif ( mac_index6 = 1) then
						buffer_value(4) <= buffer_value(4) + tmp;
					elsif ( mac_index6 = 2) then
						buffer_value(3) <= buffer_value(3) + tmp;
					elsif ( mac_index6 = 3) then
						buffer_value(2) <= buffer_value(2) + tmp;
					elsif ( mac_index6 = 4) then
						buffer_value(1) <= buffer_value(1) + tmp;
					elsif ( mac_index6 = 5) then
						buffer_value(0) <= buffer_value(0) + tmp;
						--compute_done  <= '1';

					end if;
				end if;


				when pixel_33  => 
				tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if ( buffer_shift3 = 0) then 
					if( mac_index3 = 0 ) then
						buffer_value(5) <= buffer_value(5) + tmp;
					elsif ( mac_index3 = 1) then
						buffer_value(4) <= buffer_value(4) + tmp;
					elsif ( mac_index3 = 2) then
						buffer_value(3) <= buffer_value(3) + tmp;
						--compute_done  <= '1';

					end if;
				end if;


--------------------------------------------------------------------------------
-- column 4
--------------------------------------------------------------------------------
				
				when pixel_04  => 
				tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if ( buffer_shift4 = 0) then 
					if( mac_index2 = 0 ) then
						buffer_value(1) <= buffer_value(1) + tmp;
					elsif ( mac_index2 = 1) then
						buffer_value(0) <= buffer_value(0) + tmp;
						--compute_done  <= '1';

					end if;
				end if;

				when pixel_14  => 
				tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if ( buffer_shift4 = 0) then 
					if( mac_index4 = 0 ) then
						buffer_value(4) <= buffer_value(4) + tmp;
					elsif ( mac_index4 = 1) then
						buffer_value(3) <= buffer_value(3) + tmp;
					elsif ( mac_index4 = 2) then
						buffer_value(1) <= buffer_value(1) + tmp;
					elsif ( mac_index4 = 3) then
						buffer_value(0) <= buffer_value(0) + tmp;
						--compute_done  <= '1';

					end if;
				end if;

				when pixel_24  => 
				tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if ( buffer_shift4 = 0) then 
					if( mac_index4 = 0 ) then
						buffer_value(4) <= buffer_value(4) + tmp;
					elsif ( mac_index4 = 1) then
						buffer_value(3) <= buffer_value(3) + tmp;
					elsif ( mac_index4 = 2) then
						buffer_value(1) <= buffer_value(1) + tmp;
					elsif ( mac_index4 = 3) then
						buffer_value(0) <= buffer_value(0) + tmp;
						--compute_done  <= '1';

					end if;
				end if;

				when pixel_34  => 
				tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if ( buffer_shift4 = 0) then 
					if( mac_index2 = 0 ) then
						buffer_value(4) <= buffer_value(4) + tmp;
					elsif ( mac_index2 = 1) then
						buffer_value(3) <= buffer_value(3) + tmp;
						--compute_done  <= '1';

					end if;
				end if;

--------------------------------------------------------------------------------
-- column 5
--------------------------------------------------------------------------------
				when pixel_05  => 
				tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if ( buffer_shift5 = 0) then 
					buffer_value(0) <= buffer_value(0) + tmp;
					--compute_done  <= '1';
				end if;

				when pixel_15  => 
				tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if ( buffer_shift5 = 0) then 
					if( mac_index2 = 0 ) then
						buffer_value(0) <= buffer_value(0) + tmp;
					elsif ( mac_index2 = 1) then
						buffer_value(3) <= buffer_value(3) + tmp;
						--compute_done  <= '1';
					end if;
				end if;

				when pixel_25  => 
				tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if ( buffer_shift5 = 0) then 
					if( mac_index2 = 0 ) then
						buffer_value(3) <= buffer_value(3) + tmp;
					elsif ( mac_index2 = 1) then
						buffer_value(0) <= buffer_value(0) + tmp;
						--compute_done  <= '1';
					end if;
				end if;

				when pixel_35  => 
				tmp  :=  mac_pixel_value_reg * mac_kernel_value_reg ;

				if ( buffer_shift5 = 0) then 
					buffer_value(3) <= buffer_value(3) + tmp;
					--compute_done  <= '1';
				end if;

			end case;
		end process output_network;




--mac_stop_extension: process(mac_clk)
--begin
-- if (mac_reset = '1') then 
-- 	mac_stop_buffer  <= 0;
-- elsif(rising_edge(mac_clk)) then
--    if( mac_enable = '1') then
--    	mac_stop_buffer  <= mac_stop;
--		if mac_pixel_valid = '1'  and mac_kernel_valid = '1' then
--			mac_stop  <= 0 ;
--		else
--			mac_stop  <= 1;
--		end if;
--	end if;
--end if;
--end process;

--mac_stop_extension: process(mac_clk)
--begin
-- if (mac_reset = '1') then 
-- 	calc_iteration  <= 0;
-- 	mac_stop  <= 0;
-- elsif(rising_edge(mac_clk)) then
--    if( mac_enable = '1') then
--    	if (calc_iteration  < kernel_number + 2) then
--    		calc_iteration  <= calc_iteration + 1;
--    		mac_stop  <= 0;
--    	else
--    		mac_stop  <= 1;
--    		calc_iteration  <= 0;
--    	end if;
--	end if;	
--end if;
--end process;









end rtl;
